/*
 * Decompiled with CFR 0.152.
 */
package com.hyfata.najoan.koreanpatch.mixin;

import com.hyfata.najoan.koreanpatch.client.KoreanPatchClient;
import com.hyfata.najoan.koreanpatch.keyboard.KeyboardLayout;
import com.hyfata.najoan.koreanpatch.mixin.CreativeInventoryScreenInvoker;
import com.hyfata.najoan.koreanpatch.util.HangulProcessor;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_481;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_342.class})
public abstract class TextFieldWidgetMixin {
    private Consumer<String> field_2088;
    private final class_310 client = class_310.method_1551();

    @Shadow
    public abstract int method_1881();

    @Shadow
    public abstract void method_1883(int var1);

    @Shadow
    public abstract void method_1878(int var1);

    @Shadow
    public abstract String method_1882();

    @Shadow
    public abstract void method_1867(String var1);

    @Shadow
    protected abstract boolean method_20316();

    @Shadow
    public abstract void method_1872();

    @Shadow
    public abstract void method_1874(String var1);

    @Shadow
    public abstract void method_1852(String var1);

    @Inject(at={@At(value="HEAD")}, method={"charTyped(CI)Z"}, cancellable=true)
    public void charTyped(char chr, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (this.client.field_1755 != null && KoreanPatchClient.KOREAN && this.method_20316() && Character.charCount(chr) == 1) {
            char[] chars;
            cir.setReturnValue((Object)Boolean.TRUE);
            for (char ch : chars = Character.toChars(chr)) {
                int qwertyIndex = this.getQwertyIndexCodePoint(ch);
                if (ch == ' ') {
                    this.writeText(String.valueOf(ch));
                    KeyboardLayout.INSTANCE.assemblePosition = HangulProcessor.isHangulCharacter(ch) ? this.method_1881() : -1;
                    continue;
                }
                if (qwertyIndex == -1) {
                    KeyboardLayout.INSTANCE.assemblePosition = -1;
                    continue;
                }
                char curr = KeyboardLayout.INSTANCE.layout.toCharArray()[qwertyIndex];
                int cursorPosition = this.method_1881();
                if (cursorPosition != 0 && HangulProcessor.isHangulCharacter(curr) && this.onHangulCharTyped(chr, modifiers)) continue;
                this.writeText(String.valueOf(curr));
                KeyboardLayout.INSTANCE.assemblePosition = HangulProcessor.isHangulCharacter(curr) ? this.method_1881() : -1;
            }
        }
    }

    public void writeText(String str) {
        this.method_1867(str);
        this.sendTextChanged(str);
        this.method_1874(this.method_1882());
        this.updateScreen();
    }

    private void sendTextChanged(String str) {
        if (this.field_2088 != null) {
            this.field_2088.accept(str);
        }
    }

    private void updateScreen() {
        if (this.client.field_1755 == null) {
            return;
        }
        if (this.client.field_1755 instanceof class_481 && !this.method_1882().isEmpty()) {
            ((CreativeInventoryScreenInvoker)this.client.field_1755).updateCreativeSearch();
        }
    }

    public void modifyText(char ch) {
        int cursorPosition = this.method_1881();
        this.method_1883(cursorPosition - 1);
        this.method_1878(1);
        this.writeText(String.valueOf(Character.toChars(ch)));
    }

    @Inject(at={@At(value="HEAD")}, method={"keyPressed(III)Z"}, cancellable=true)
    private void keyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> callbackInfo) {
        class_310 client = class_310.method_1551();
        if (client.field_1755 != null) {
            if (keyCode == KoreanPatchClient.KEYCODE || scanCode == KoreanPatchClient.SCANCODE) {
                KoreanPatchClient.KOREAN = !KoreanPatchClient.KOREAN;
                boolean bl = KoreanPatchClient.KOREAN;
            }
            if (keyCode == 259) {
                int cursorPosition = this.method_1881();
                if (cursorPosition == 0 || cursorPosition != KeyboardLayout.INSTANCE.assemblePosition) {
                    return;
                }
                String text = this.method_1882();
                char ch = text.toCharArray()[cursorPosition - 1];
                if (HangulProcessor.isHangulSyllables(ch)) {
                    int code = ch - 44032;
                    int cho = code / 588;
                    int jung = code % 588 / 28;
                    int jong = code % 588 % 28;
                    if (jong != 0) {
                        char[] ch_arr = KeyboardLayout.INSTANCE.jongsung_ref_table.get(jong).toCharArray();
                        jong = ch_arr.length == 2 ? KeyboardLayout.INSTANCE.jongsung_table.indexOf(ch_arr[0]) : 0;
                        char c = HangulProcessor.synthesizeHangulCharacter(cho, jung, jong);
                        this.modifyText(c);
                    } else {
                        char[] ch_arr = KeyboardLayout.INSTANCE.jungsung_ref_table.get(jung).toCharArray();
                        if (ch_arr.length == 2) {
                            jung = KeyboardLayout.INSTANCE.jungsung_table.indexOf(ch_arr[0]);
                            char c = HangulProcessor.synthesizeHangulCharacter(cho, jung, 0);
                            this.modifyText(c);
                        } else {
                            char c = KeyboardLayout.INSTANCE.chosung_table.charAt(cho);
                            this.modifyText(c);
                        }
                    }
                    callbackInfo.setReturnValue((Object)Boolean.TRUE);
                } else if (HangulProcessor.isHangulCharacter(ch)) {
                    KeyboardLayout.INSTANCE.assemblePosition = -1;
                }
            }
        }
    }

    private int getQwertyIndexCodePoint(char ch) {
        return KeyboardLayout.INSTANCE.qwerty_layout.indexOf(ch);
    }

    boolean onHangulCharTyped(int keyCode, int modifiers) {
        int idx;
        boolean shift = (modifiers & 1) == 1;
        int codePoint = keyCode;
        if (codePoint >= 65 && codePoint <= 90) {
            codePoint += 32;
        }
        if (codePoint >= 97 && codePoint <= 122 && shift) {
            codePoint -= 32;
        }
        if ((idx = KeyboardLayout.INSTANCE.qwerty_layout.indexOf(codePoint)) == -1) {
            KeyboardLayout.INSTANCE.assemblePosition = -1;
            return false;
        }
        int cursorPosition = this.method_1881();
        String text = this.method_1882();
        char prev = text.toCharArray()[cursorPosition - 1];
        char curr = KeyboardLayout.INSTANCE.layout.toCharArray()[idx];
        if (cursorPosition == 0) {
            if (!HangulProcessor.isHangulCharacter(curr)) {
                return false;
            }
            this.writeText(String.valueOf(curr));
            KeyboardLayout.INSTANCE.assemblePosition = this.method_1881();
        } else if (cursorPosition == KeyboardLayout.INSTANCE.assemblePosition) {
            if (HangulProcessor.isJaeum(prev) && HangulProcessor.isMoeum(curr)) {
                int cho = KeyboardLayout.INSTANCE.chosung_table.indexOf(prev);
                int jung = KeyboardLayout.INSTANCE.jungsung_table.indexOf(curr);
                char c = HangulProcessor.synthesizeHangulCharacter(cho, jung, 0);
                this.modifyText(c);
                KeyboardLayout.INSTANCE.assemblePosition = this.method_1881();
                return true;
            }
            if (HangulProcessor.isHangulSyllables(prev)) {
                int code = prev - 44032;
                int cho = code / 588;
                int jung = code % 588 / 28;
                int jong = code % 588 % 28;
                if (jong == 0 && HangulProcessor.isJungsung(prev, curr)) {
                    jung = HangulProcessor.getJungsung(prev, curr);
                    char c = HangulProcessor.synthesizeHangulCharacter(cho, jung, 0);
                    this.modifyText(c);
                    KeyboardLayout.INSTANCE.assemblePosition = this.method_1881();
                    return true;
                }
                if (jong == 0 && HangulProcessor.isJongsung(curr)) {
                    char c = HangulProcessor.synthesizeHangulCharacter(cho, jung, HangulProcessor.getJongsung(curr));
                    this.modifyText(c);
                    KeyboardLayout.INSTANCE.assemblePosition = this.method_1881();
                    return true;
                }
                if (jong != 0 && HangulProcessor.isJongsung(prev, curr)) {
                    jong = HangulProcessor.getJongsung(prev, curr);
                    char c = HangulProcessor.synthesizeHangulCharacter(cho, jung, jong);
                    this.modifyText(c);
                    KeyboardLayout.INSTANCE.assemblePosition = this.method_1881();
                    return true;
                }
                if (jong != 0 && HangulProcessor.isJungsung(curr)) {
                    int newCho;
                    char[] tbl = KeyboardLayout.INSTANCE.jongsung_ref_table.get(jong).toCharArray();
                    if (tbl.length == 2) {
                        newCho = KeyboardLayout.INSTANCE.chosung_table.indexOf(tbl[1]);
                        jong = KeyboardLayout.INSTANCE.jongsung_table.indexOf(tbl[0]);
                    } else {
                        Objects.requireNonNull(KeyboardLayout.INSTANCE);
                        newCho = KeyboardLayout.INSTANCE.chosung_table.indexOf("\u0000\u3131\u3132\u3133\u3134\u3135\u3136\u3137\u3139\u313a\u313b\u313c\u313d\u313e\u313f\u3140\u3141\u3142\u3144\u3145\u3146\u3147\u3148\u314a\u314b\u314c\u314d\u314e".charAt(jong));
                        jong = 0;
                    }
                    char c = HangulProcessor.synthesizeHangulCharacter(cho, jung, jong);
                    this.modifyText(c);
                    cho = newCho;
                    jung = KeyboardLayout.INSTANCE.jungsung_table.indexOf(curr);
                    code = HangulProcessor.synthesizeHangulCharacter(cho, jung, 0);
                    this.writeText(String.valueOf(Character.toChars(code)));
                    KeyboardLayout.INSTANCE.assemblePosition = this.method_1881();
                    return true;
                }
            }
        }
        this.writeText(String.valueOf(curr));
        KeyboardLayout.INSTANCE.assemblePosition = this.method_1881();
        return true;
    }
}

