/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.colorspace;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.platform.GlStateManager;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Objects;
import net.coderbot.iris.colorspace.ColorSpace;
import net.coderbot.iris.colorspace.ColorSpaceConverter;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.program.Program;
import net.coderbot.iris.gl.program.ProgramBuilder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.postprocess.FullScreenQuadRenderer;
import net.coderbot.iris.shaderpack.StringPair;
import net.coderbot.iris.shaderpack.preprocessor.JcppProcessor;
import org.apache.commons.io.IOUtils;
import org.joml.Matrix4f;

public class ColorSpaceFragmentConverter
implements ColorSpaceConverter {
    private int width;
    private int height;
    private ColorSpace colorSpace;
    private Program program;
    private GlFramebuffer framebuffer;
    private int swapTexture;
    private int target;

    public ColorSpaceFragmentConverter(int n, int n2, ColorSpace colorSpace) {
        this.rebuildProgram(n, n2, colorSpace);
    }

    @Override
    public void rebuildProgram(int n, int n2, ColorSpace colorSpace) {
        String string;
        String string2;
        if (this.program != null) {
            this.program.destroy();
            this.program = null;
            this.framebuffer.destroy();
            this.framebuffer = null;
            GlStateManager._deleteTexture((int)this.swapTexture);
            this.swapTexture = 0;
        }
        this.width = n;
        this.height = n2;
        this.colorSpace = colorSpace;
        try {
            string2 = new String(IOUtils.toByteArray((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("/colorSpace.vsh"))), StandardCharsets.UTF_8);
            string = new String(IOUtils.toByteArray((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("/colorSpace.csh"))), StandardCharsets.UTF_8);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        ArrayList<StringPair> arrayList = new ArrayList<StringPair>();
        arrayList.add(new StringPair("CURRENT_COLOR_SPACE", String.valueOf(colorSpace.ordinal())));
        for (ColorSpace colorSpace2 : ColorSpace.values()) {
            arrayList.add(new StringPair(colorSpace2.name(), String.valueOf(colorSpace2.ordinal())));
        }
        string = JcppProcessor.glslPreprocessSource(string, arrayList);
        ProgramBuilder programBuilder = ProgramBuilder.begin("colorSpaceFragment", string2, null, string, (ImmutableSet<Integer>)ImmutableSet.of());
        programBuilder.uniformMatrix(UniformUpdateFrequency.ONCE, "projection", () -> new Matrix4f(2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, -1.0f, 0.0f, 1.0f));
        programBuilder.addDynamicSampler(() -> this.target, "readImage");
        this.swapTexture = GlStateManager._genTexture();
        IrisRenderSystem.texImage2D(this.swapTexture, 3553, 0, 32856, n, n2, 0, 6408, 5121, null);
        this.framebuffer = new GlFramebuffer();
        this.framebuffer.addColorAttachment(0, this.swapTexture);
        this.program = programBuilder.build();
    }

    @Override
    public void process(int n) {
        if (this.colorSpace == ColorSpace.SRGB) {
            return;
        }
        this.target = n;
        this.program.use();
        this.framebuffer.bind();
        FullScreenQuadRenderer.INSTANCE.render();
        Program.unbind();
        this.framebuffer.bindAsReadBuffer();
        IrisRenderSystem.copyTexSubImage2D(n, 3553, 0, 0, 0, 0, 0, this.width, this.height);
    }
}

