/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.util.workarounds.platform.windows;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.SharedLibrary;

public class Kernel32 {
    private static final SharedLibrary LIBRARY = Library.loadNative((String)"me.jellyquid.mods.sodium", (String)"kernel32");
    private static final long PFN_GetCommandLineW = APIUtil.apiGetFunctionAddress((FunctionProvider)LIBRARY, (String)"GetCommandLineW");
    private static final long PFN_SetEnvironmentVariableW = APIUtil.apiGetFunctionAddress((FunctionProvider)LIBRARY, (String)"SetEnvironmentVariableW");

    public static void setEnvironmentVariable(String name, @Nullable String value) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            ByteBuffer lpNameBuf = stack.malloc(16, MemoryUtil.memLengthUTF16((CharSequence)name, (boolean)true));
            MemoryUtil.memUTF16((CharSequence)name, (boolean)true, (ByteBuffer)lpNameBuf);
            ByteBuffer lpValueBuf = null;
            if (value != null) {
                lpValueBuf = stack.malloc(16, MemoryUtil.memLengthUTF16((CharSequence)value, (boolean)true));
                MemoryUtil.memUTF16((CharSequence)value, (boolean)true, (ByteBuffer)lpValueBuf);
            }
            JNI.callJJI((long)MemoryUtil.memAddress0((Buffer)lpNameBuf), (long)MemoryUtil.memAddressSafe(lpValueBuf), (long)PFN_SetEnvironmentVariableW);
        }
    }

    public static long getCommandLine() {
        return JNI.callP((long)PFN_GetCommandLineW);
    }
}

