/*
 * Decompiled with CFR 0.152.
 */
package com.hyfata.najoan.koreanpatch.mixin;

import com.hyfata.najoan.koreanpatch.client.KoreanPatchClient;
import com.hyfata.najoan.koreanpatch.keyboard.KeyboardLayout;
import com.hyfata.najoan.koreanpatch.util.HangulProcessor;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_310;
import net.minecraft.class_3728;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3728.class})
public abstract class SelectionManagerMixin {
    @Shadow
    private int field_16453;
    @Shadow
    private int field_16452;
    @Shadow
    @Final
    private Supplier<String> field_24257;
    @Shadow
    @Final
    private Predicate<String> field_24259;
    @Shadow
    @Final
    private Consumer<String> field_24258;
    private final class_310 client = class_310.method_1551();

    @Inject(at={@At(value="HEAD")}, method={"insert(C)Z"}, cancellable=true)
    public void insertChar(char chr, CallbackInfoReturnable<Boolean> cir) {
        if (this.client.field_1755 != null && KoreanPatchClient.KOREAN) {
            cir.setReturnValue((Object)Boolean.TRUE);
            if (chr == ' ') {
                this.writeText(String.valueOf(chr));
                KeyboardLayout.INSTANCE.assemblePosition = HangulProcessor.isHangulCharacter(chr) ? this.field_16452 : -1;
                return;
            }
            int qwertyIndex = this.getQwertyIndexCodePoint(chr);
            if (qwertyIndex == -1) {
                KeyboardLayout.INSTANCE.assemblePosition = -1;
                return;
            }
            char curr = KeyboardLayout.INSTANCE.layout.toCharArray()[qwertyIndex];
            int cursorPosition = this.field_16452;
            int modifiers = this.getChosungModifiersIndexCodePoint(curr);
            if (cursorPosition == 0 || !HangulProcessor.isHangulCharacter(curr) || !this.onHangulCharTyped(chr, modifiers)) {
                this.writeText(String.valueOf(curr));
                KeyboardLayout.INSTANCE.assemblePosition = HangulProcessor.isHangulCharacter(curr) ? this.field_16452 : -1;
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"insert(Ljava/lang/String;)V"}, cancellable=true)
    public void insertString(String string, CallbackInfo ci) {
        char[] chrs;
        for (char chr : chrs = string.toCharArray()) {
            if (this.client.field_1755 == null || !KoreanPatchClient.KOREAN) continue;
            ci.cancel();
            if (chr == ' ') {
                this.writeText(String.valueOf(chr));
                KeyboardLayout.INSTANCE.assemblePosition = HangulProcessor.isHangulCharacter(chr) ? this.field_16452 : -1;
                continue;
            }
            int qwertyIndex = this.getQwertyIndexCodePoint(chr);
            if (qwertyIndex == -1) {
                KeyboardLayout.INSTANCE.assemblePosition = -1;
                continue;
            }
            char curr = KeyboardLayout.INSTANCE.layout.toCharArray()[qwertyIndex];
            int cursorPosition = this.field_16452;
            int modifiers = this.getChosungModifiersIndexCodePoint(curr);
            if (cursorPosition != 0 && HangulProcessor.isHangulCharacter(curr) && this.onHangulCharTyped(chr, modifiers)) continue;
            this.writeText(String.valueOf(curr));
            KeyboardLayout.INSTANCE.assemblePosition = HangulProcessor.isHangulCharacter(curr) ? this.field_16452 : -1;
        }
    }

    private int getQwertyIndexCodePoint(char ch) {
        return KeyboardLayout.INSTANCE.qwerty_layout.indexOf(ch);
    }

    private int getChosungModifiersIndexCodePoint(char curr) {
        int idx = KeyboardLayout.INSTANCE.chosung_modifiers_table.indexOf(curr);
        if (idx > -1) {
            return 1;
        }
        return 0;
    }

    public String getText() {
        return this.field_24257.get();
    }

    public void writeText(String str) {
        int cursorPosition = this.field_16452;
        String s = this.getText();
        String res = cursorPosition > 0 ? s.substring(0, cursorPosition) + str + s.substring(cursorPosition) : str + s;
        boolean textCommitted = this.setText(res);
        if (textCommitted && this.getText().length() == res.length()) {
            this.field_16452 = cursorPosition + 1;
            this.field_16453 = cursorPosition + 1;
        }
    }

    public boolean setText(String str) {
        if (this.field_24259.test(str)) {
            this.field_24258.accept(str);
            return true;
        }
        return false;
    }

    public void modifyText(char ch) {
        int cursorPosition = this.field_16452;
        char[] arr = this.getText().toCharArray();
        if (cursorPosition > 0 && cursorPosition <= arr.length) {
            arr[cursorPosition - 1] = ch;
            this.setText(String.valueOf(arr));
        }
    }

    boolean onHangulCharTyped(int keyCode, int modifiers) {
        int idx;
        boolean shift = (modifiers & 1) == 1;
        int codePoint = keyCode;
        if (codePoint >= 65 && codePoint <= 90) {
            codePoint += 32;
        }
        if (codePoint >= 97 && codePoint <= 122 && shift) {
            codePoint -= 32;
        }
        if ((idx = KeyboardLayout.INSTANCE.qwerty_layout.indexOf(codePoint)) == -1) {
            KeyboardLayout.INSTANCE.assemblePosition = -1;
            return false;
        }
        int cursorPosition = this.field_16452;
        String text = this.getText();
        char prev = text.toCharArray()[cursorPosition - 1];
        char curr = KeyboardLayout.INSTANCE.layout.toCharArray()[idx];
        if (cursorPosition == 0) {
            if (!HangulProcessor.isHangulCharacter(curr)) {
                return false;
            }
            this.writeText(String.valueOf(curr));
            KeyboardLayout.INSTANCE.assemblePosition = this.field_16452;
        } else if (cursorPosition == KeyboardLayout.INSTANCE.assemblePosition) {
            if (HangulProcessor.isJaeum(prev) && HangulProcessor.isMoeum(curr)) {
                int cho = KeyboardLayout.INSTANCE.chosung_table.indexOf(prev);
                int jung = KeyboardLayout.INSTANCE.jungsung_table.indexOf(curr);
                char c = HangulProcessor.synthesizeHangulCharacter(cho, jung, 0);
                this.modifyText(c);
                KeyboardLayout.INSTANCE.assemblePosition = this.field_16452;
                return true;
            }
            if (HangulProcessor.isHangulSyllables(prev)) {
                int code = prev - 44032;
                int cho = code / 588;
                int jung = code % 588 / 28;
                int jong = code % 588 % 28;
                if (jong == 0 && HangulProcessor.isJungsung(prev, curr)) {
                    jung = HangulProcessor.getJungsung(prev, curr);
                    char c = HangulProcessor.synthesizeHangulCharacter(cho, jung, 0);
                    this.modifyText(c);
                    KeyboardLayout.INSTANCE.assemblePosition = this.field_16452;
                    return true;
                }
                if (jong == 0 && HangulProcessor.isJongsung(curr)) {
                    char c = HangulProcessor.synthesizeHangulCharacter(cho, jung, HangulProcessor.getJongsung(curr));
                    this.modifyText(c);
                    KeyboardLayout.INSTANCE.assemblePosition = this.field_16452;
                    return true;
                }
                if (jong != 0 && HangulProcessor.isJongsung(prev, curr)) {
                    jong = HangulProcessor.getJongsung(prev, curr);
                    char c = HangulProcessor.synthesizeHangulCharacter(cho, jung, jong);
                    this.modifyText(c);
                    KeyboardLayout.INSTANCE.assemblePosition = this.field_16452;
                    return true;
                }
                if (jong != 0 && HangulProcessor.isJungsung(curr)) {
                    int newCho;
                    char[] tbl = KeyboardLayout.INSTANCE.jongsung_ref_table.get(jong).toCharArray();
                    if (tbl.length == 2) {
                        newCho = KeyboardLayout.INSTANCE.chosung_table.indexOf(tbl[1]);
                        jong = KeyboardLayout.INSTANCE.jongsung_table.indexOf(tbl[0]);
                    } else {
                        Objects.requireNonNull(KeyboardLayout.INSTANCE);
                        newCho = KeyboardLayout.INSTANCE.chosung_table.indexOf("\u0000\u3131\u3132\u3133\u3134\u3135\u3136\u3137\u3139\u313a\u313b\u313c\u313d\u313e\u313f\u3140\u3141\u3142\u3144\u3145\u3146\u3147\u3148\u314a\u314b\u314c\u314d\u314e".charAt(jong));
                        jong = 0;
                    }
                    char c = HangulProcessor.synthesizeHangulCharacter(cho, jung, jong);
                    this.modifyText(c);
                    cho = newCho;
                    jung = KeyboardLayout.INSTANCE.jungsung_table.indexOf(curr);
                    code = HangulProcessor.synthesizeHangulCharacter(cho, jung, 0);
                    this.writeText(String.valueOf(Character.toChars(code)));
                    KeyboardLayout.INSTANCE.assemblePosition = this.field_16452;
                    return true;
                }
            }
        }
        this.writeText(String.valueOf(curr));
        KeyboardLayout.INSTANCE.assemblePosition = this.field_16452;
        return true;
    }
}

